//
//  UIViewController+.swift
//  YTBase_Example
//
//  Created by YouT on 2020/9/16.
//  Copyright © 2020 CocoaPods. All rights reserved.
//

import Foundation

extension UIViewController {
    
}

public extension YTBase where Base == UIViewController {
     static var visibleViewContoller:UIViewController? {
         func visibleViewContoller(_ fromViewContoller:UIViewController? = nil) -> UIViewController? {
             guard let curViewC = fromViewContoller else { return nil }
             if let preViewC = curViewC.presentedViewController {
                 return visibleViewContoller(preViewC)
             }
             switch curViewC {
             case is UINavigationController:
                 return visibleViewContoller((curViewC as! UINavigationController).visibleViewController)
             case is UITabBarController :
                 return visibleViewContoller((curViewC as! UITabBarController).selectedViewController)
             default:
                 return curViewC
             }
         }
         return visibleViewContoller(UIWindow.yt.visibleWindow?.rootViewController)
     }
    

    
    
}







