//
//  YTBase.swift
//  YTBase
//
//  Created by YouT on 2020/12/4.
//

import Foundation

public struct YTBase<Base> {
    let base:Base
    init(_ base:Base) {
        self.base = base
    }
}

public protocol YTBaseCompatible {}

public extension YTBaseCompatible {
    var yt:YTBase<Self> {
        get {
            YTBase<Self>(self)
        }
        set{}
    }
    
    static var yt:YTBase<Self>.Type {
        get {
            YTBase<Self>.self
        }
        set {}
    }
}

extension NSObject: YTBaseCompatible {}
