//
//  TWDocumentVC.h
//  sfs
//
//  Created by fishxiaou on 16/12/5.
//  Copyright © 2016年 fishxiaou. All rights reserved.
//

#import <UIKit/UIKit.h>

/**
 *  文件分享、接受到的文件处理页面
 */
@interface TWDocumentVC : UIViewController
//  传入文件source
+(void)showWihtSourceUrl:(NSURL *)url fromViewController:(UIViewController *)superViewController;

@end


/**
 *  文件操作(保存、删除)
 */
@interface DocumentTools : NSObject

/** 本地路径下面的文件数组*/
@property (nonatomic,strong) NSMutableArray *fileArr;

///** 本地路径下面的文件数组(赛选后)*/
//@property (nonatomic,strong) NSMutableArray *filterFileArr;

// 获取本地文件库路径
-(NSString *)theTWDocumentPatch;

// 获取图标
+(NSString *)fileExtension:(NSString *)fileName;
// 获取文件的创建时间
+(NSString *)getCreatDate:(NSString* )path;

// 保存网络文件到本地沙盒
-(void)saveFileToApp:(NSURL *)url withFileName:(NSString *)fileName andResultBack:
(void(^)(float,bool))downloadCall;

// 保存路径文件到本地沙盒
-(BOOL)saveFileToApp:(NSURL *)filePath;
// 删除指定路径的文件
-(BOOL)removeFileFromPath:(NSString *)filePath;

// 本地文件检索
-(NSMutableArray *)filterFileActionWithNameStr:(NSString *)filterStr;

@end
