//
//  YTPicture_Vc.swift
//  TWIM
//
//  Created by YouT on 2020/9/3.
//  Copyright © 2020 fsToone. All rights reserved.
//

import UIKit
import Kingfisher

public class YTPicture_Vc: UIViewController, UIScrollViewDelegate {
    
   public var imageData: Data?
   public var imagePath: String?
   public var imageName:String?
    
    var isPresent:Bool {
        get {
            return self.presentingViewController != nil
        }
    }
    
   private lazy var curImageView: UIImageView = {
        let theIv: UIImageView = UIImageView(frame: CGRect.zero)
        theIv.contentMode = UIView.ContentMode.scaleAspectFit
        theIv.backgroundColor = UIColor.groupTableViewBackground
        return theIv
    }()
    
   private lazy var curScrollView: UIScrollView = {
        let theSc = UIScrollView(frame: CGRect.zero)
        theSc.delegate = self
        theSc.maximumZoomScale = 2.0
        theSc.minimumZoomScale = 1
        theSc.backgroundColor = UIColor.white
        theSc.contentSize = CGSize.zero
        return theSc
    }()
    
    private lazy var backButton: UIButton = {
        let backBtn = UIButton(type: UIButton.ButtonType.custom)
        backBtn.setImage(UIImage(named: "icon_back_black"), for: .normal)
        backBtn.addTarget(self, action: #selector(self.backButtonAction), for: UIControl.Event.touchUpInside)
        
        return backBtn
    }()
    
    private lazy var titleLabel: UILabel = {
        let label = UILabel()
        label.textColor = UIColor(hexString: "#333333")
        label.font = UIFont(name: "PingFangSC-Medium",size: 16)
        label.textAlignment = .center
        
        return label
     }()
    
    public override func viewDidLoad() {
        super.viewDidLoad()
        addCustomerBackItem()
        
        if isPresent {
            self.view.backgroundColor = .white
            self.view.addSubview(backButton)
            self.view.addSubview(titleLabel)
            
            backButton.frame = CGRect(x: 16, y: 12, width: 44, height: 44)
            titleLabel.frame = CGRect(x: (self.view.width - 200) / 2.0, y: 12, width: 200, height: 44)
            
            titleLabel.text = imageName ?? "图片"

        }
        
        let w = view.frame.size.width
        let h = view.frame.size.height - (isPresent ? 50 : 0)
        curImageView.frame = CGRect(x: 0, y: (isPresent ? 50 : 0), width: w, height: h)
        curScrollView.frame = CGRect(x: 0, y: (isPresent ? 50 : 0), width: w, height: h)
        curScrollView.contentSize = CGSize(width: w, height: h)
        curScrollView.addSubview(curImageView)
        view.addSubview(curScrollView)
        
        if let theImageData = imageData, let Image = UIImage(data: theImageData) {
            curImageView.image = Image
            return
        }
        
        if let url = imagePath {
            curImageView.kf.setImage(with: URL(string: url))
        }
        navigationItem.title = imageName ?? "图片"
    }
    
    public func viewForZooming(in scrollView: UIScrollView) -> UIView? {
        return curImageView
    }
    
    func addCustomerBackItem(_ titleStr:String = "") {
        let backBtn = UIButton(type: UIButton.ButtonType.custom)
        backBtn.frame = CGRect(x: 0, y: 0, width: 44, height: 44)
        if titleStr.isEmpty {
            backBtn.setImage(UIImage(named: "icon_back_black"), for: .normal)
        }else{
            backBtn.setTitle(titleStr, for: .normal)
            backBtn.setTitleColor(UIColor(hexString: "#333333"), for: UIControl.State.normal)
            backBtn.titleLabel?.font = UIFont(name: "PingFangSC-Medium",size: 16)
        }
        backBtn.addTarget(self, action: #selector(self.backItemAction), for: UIControl.Event.touchUpInside)
        navigationItem.leftBarButtonItem = UIBarButtonItem(customView: backBtn)
    }
    
    @objc func backItemAction() {
        if let navigationC = navigationController {
            if navigationC.viewControllers.count == 1 {
                dismiss(animated: true, completion: nil)
            }else{
                navigationController?.popViewController(animated: true)
            }
        }
    }
    
    @objc func backButtonAction() {
        self.dismiss(animated: true)
    }
}

